// -*-Igor-*-
// ###################################################################
//  Igor Pro - JEG Image Tools
// 
//  FILE: "JEG Window Hooks"
//                                    created: 11/17/99 {11:09:30 AM} 
//                                last update: 8/5/03 {1:53:45 PM} 
//  Author: Jonathan Guyer
//  E-mail: jguyer@his.com
//    mail: POMODORO no seisan
//     www: http://www.his.com/jguyer/
//  
// Copyright (c) 1999-2003, Jonathan Guyer
// All rights reserved.
// 
// Redistribution and use in source and binary forms, with or
// without modification, are permitted provided that the following
// conditions are met:
// 
//     Redistributions of source code must retain the above
//     copyright notice, this list of conditions and the following
//     disclaimer.
// 
//     Redistributions in binary form must reproduce the above
//     copyright notice, this list of conditions and the following
//     disclaimer in the documentation and/or other materials
//     provided with the distribution.
// 
//     Neither name of POMODORO no seisan nor the names of its
//     contributors may be used to endorse or promote products
//     derived from this software without specific prior written
//     permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
// CONTRIBUTORS ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES,
// INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
// LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,
// OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
// PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,
// OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
// TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
// OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
// OF SUCH DAMAGE.
// 
//  Description: 
// 
//  History
// 
//  modified   by  rev reason
//  ---------- --- --- -----------
//  1999-11-17 JEG 1.0 original
//  2003-08-05 JEG 1.1 Window hooks must return 0 unless they do something.
//                     Igor 4 now required for FUNCREFs
// ###################################################################
// 
#pragma rtGlobals=1		// Use modern global access method.

#pragma IgorVersion=4

Function JEG_WindowHook_Set(window,proc)
	String window, proc
	
	String df= GetDataFolder(1)
	NewDataFolder/O root:WinGlobals
	NewDataFolder/O/S root:WinGlobals:$window
	
	Wave/T windowHooks = JEG_WindowHooks

	GetWindow $window, hook
	
	if (WaveExists(windowHooks) %& cmpstr(S_Value,"JEG_WindowHook_Do") == 0)
		Variable numHooks = numpnts(windowHooks)
		
		Variable i = numHooks - 1	
		do
			if (i < 0)
				break // this breaks out of the loop
			endif
			if (cmpstr(windowHooks[i], proc) == 0)
				break
			endif
			i -= 1
		while(1) 	
		if (i < 0)
			Redimension/N=(numHooks + 1) windowHooks
			windowHooks[numHooks+1] = proc		
		endif
	else
		Make/T/O/N=1 JEG_WindowHooks
		JEG_WindowHooks[0] = proc
		SetWindow $window, hook = JEG_WindowHook_Do
	endif
	
	SetDataFolder df
End

Function JEG_WindowHook_Unset(window,proc)
	String window, proc
	
	String df= GetDataFolder(1)
	NewDataFolder/O root:WinGlobals
	NewDataFolder/O/S root:WinGlobals:$window

	Wave/T windowHooks = JEG_WindowHooks

	GetWindow $window, hook
	
	if (cmpstr(S_Value,"JEG_WindowHook_Do") == 0)
		Variable numHooks = numpnts(windowHooks)
		Variable i = numHooks - 1	
		do
			if (i < 0)
				break // this breaks out of the loop
			endif
			if (cmpstr(windowHooks[i], proc) == 0)
				DeletePoints i, 1, windowHooks
				break
			endif
			i -= 1
		while(1) 	
	elseif (cmpstr(S_Value, proc))
		// At this point, this wave shouldn't even exist, but kill it anyway
		KillWaves/Z windowHooks
		SetWindow $window, hook =$""
	else
		print "No such hook:", proc
	endif
	
	SetDataFolder df
End

Function JEG_WindowHook_Do(infoStr)
	String infoStr
	
	String window = StringByKey("WINDOW",infoStr)
	
	String df= GetDataFolder(1)
	NewDataFolder/O root:WinGlobals
	NewDataFolder/O/S root:WinGlobals:$window
	
	Wave/T windowHooks = JEG_WindowHooks
	
	Variable handled = 0
	
	if (WaveExists(windowHooks))
		Variable numHooks = numpnts(windowHooks)
		String s
		Variable i = 0	
		do
			if (i >= numHooks)
				break // this breaks out of the loop
			endif
			
			// Hooks must explicitly return 0 or 1 now.  Hooks blithely
			// returning 1 cause Igors menus not to work.  This way, we only
			// return 1 if one of the hooks returns 1.

			// I know of no way to get a result from Execute,
			// so use FUNCREF. More elegant, but less backward
			// compatible.
			FUNCREF JEG_WindowHook_Do hook = $windowHooks[i]
			handled = handled | hook(infoStr)
			
			i += 1
		while(1) 	
	endif
	
	if (cmpstr(StringByKey("EVENT",infoStr), "kill") == 0)
		KillWaves/Z windowHooks
	endif

	SetDataFolder df
	
	return handled
End
